package ch.brx.simpledialer;


import java.util.List;

import android.net.Uri;
import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup.LayoutParams;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;

public class MainActivity extends Activity implements OnClickListener {

	private EditText et;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		// Get intent, action and MIME type
		Intent intent = getIntent();
		String action = intent.getAction();

		if (Intent.ACTION_DIAL.equals(action)) {
			Uri number = intent.getData();
			et = (EditText)findViewById(R.id.number);
			LinearLayout ll = (LinearLayout)findViewById(R.id.LinearLayout1);
			
			String plain_number = number.toString().replace("tel:", "");
			
			if(number.toString().startsWith("tel:"))
			{
				et.setText(plain_number);
			}
			
			Intent ci = new Intent(Intent.ACTION_CALL);
			ci.setData(Uri.parse("tel:"+plain_number ));
			
			PackageManager pm = getPackageManager();
			List<ResolveInfo> lr = pm.queryIntentActivities(ci, 0);
			for(ResolveInfo i: lr)
			{
				Button myButton = new Button(this);
				myButton.setText("Call using " + i.loadLabel(pm) );
				myButton.setTag(i.activityInfo.applicationInfo.packageName);
				myButton.setOnClickListener(this);
				
				LayoutParams lp = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
				ll.addView(myButton, lp);
			}
		}
	}
	
	public void onClick(View v) {
		Button btn = (Button)v;
		
		Intent ci = new Intent(Intent.ACTION_CALL);
		ci.setData(Uri.parse("tel:"+et.getText().toString() ));
		ci.setPackage((String)btn.getTag());
		startActivity(ci);
		finish();
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

}
