package ch.brx.ldifviewer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;

import android.content.Context;

public class TemplateManager {

	static final String TEMPLATE_FOLDER = "/templates/";
	
	static TemplateManager obj = null;
	boolean use_internal = false;
	Context ctx;
	
	
	static private void initManager(Context ctx)
	{
		obj = new TemplateManager(ctx);
		obj.initTemplateFolder(false);
		//obj.readTemplateList();
	}
	
	static TemplateManager getManager(Context ctx)
	{
		if(obj == null)
		{
			initManager(ctx);
		}
		
		return obj;
	}

	public class TemplateFile implements Comparable<TemplateFile> {
		String name;
		String filename;
		boolean internal;
		
		TemplateFile(String name, String filename, boolean internal)
		{
			this.name = name;
			this.filename = filename;
			this.internal = internal;
		}
		
		public int compareTo(TemplateFile another) {
			return name.compareToIgnoreCase(another.name);
		}

		@Override
		public String toString()
		{
			return name;
		}
	}

	TemplateManager(Context ctx)
	{
		this.ctx = ctx;
	}
	
	public boolean externalTemplates()
	{
		return !use_internal;
	}
	
	private void copyFilefromAssets(String asset, boolean replace)
	{
		int b;
		String outName = templatePath(asset);
		
		try {

			
			File file = new File(outName);
			if(file.exists() && !replace)
			{
				return;
			}
			
			FileOutputStream ofile = new FileOutputStream(outName);
			
			InputStream ifile = ctx.getAssets().open("contact_template/" + asset);

			while( (b = ifile.read()) >= 0 )
			{
				ofile.write(b);
			}

			ofile.close();
		}
		catch(FileNotFoundException e)
		{
			System.err.println("TplCopy: "+e.toString());
		}
		catch(IOException e)
		{
			System.err.println("TplCopy: "+e.toString());
		}
	}
	
	public void resetTemplate(String file)
	{
		File f = new File(file);
		copyFilefromAssets(f.getName(), true);
	}
	
	public String templatePath(String file)
	{
		String folder = ctx.getExternalFilesDir(null).getAbsolutePath().concat(TEMPLATE_FOLDER);
		if(file == null)
		{
			return folder;
		}
		return folder.concat(file);
	}
	
	private String[] getAssetFiles()
	{
		String[] assetFiles;
		try {
			assetFiles = ctx.getAssets().list("contact_template");
		}
		catch(IOException e)
		{
			System.err.println("TplCopy: "+e.toString());
			return new String[0];
		}
		return assetFiles;
	}

	private void initTemplateFolder(boolean reset)
	{
		if(!use_internal)
		{
			try {
				File dir = new File(templatePath(null));
				if(dir.exists() == false)
				{
					dir.mkdir();
				}

				if(dir.exists())
				{
					String[] assetFiles = getAssetFiles();
					for(String f : assetFiles)
					{
						copyFilefromAssets(f, reset);
					}
				}
				else
				{
					use_internal = true;
				}
			}
			catch(NullPointerException ne)
			{
				use_internal = true;
			}
		}
	}
	
	private ArrayList<TemplateFile> readTemplateList()
	{
		ArrayList<TemplateFile> templates = new ArrayList<TemplateFile>();
		String[] assetFiles = getAssetFiles();
		
		if(use_internal)
		{
			for(String f: assetFiles)
			{
				String fullf = "contact_template/" + f;
				TemplateReader tmplrdr = new TemplateReader(ctx, fullf);
				TemplateFile record = new TemplateFile(tmplrdr.getTemplateName(), fullf, true);
				templates.add(record);
			}
		}
		else
		{
			String[] files = new File(templatePath(null)).list();
			for(String f: files)
			{
				String fullf = templatePath(f);
				TemplateReader tmplrdr = new TemplateReader(ctx, fullf);

				boolean internal = false;
				for(String a : assetFiles)
				{
					if(f.equals(a))
					{
						internal = true;
						break;
					}

				}
				TemplateFile record = new TemplateFile(tmplrdr.getTemplateName(), fullf, internal);
				templates.add(record);
			}
		}
		
		Collections.sort(templates);
		return templates;
	}
	
	TemplateFile[] getTemplates()
	{
		ArrayList<TemplateFile> templates = readTemplateList();
		
		TemplateFile[] tmp = new TemplateFile[templates.size()];
		for(int ix = 0; ix < templates.size(); ix++)
		{
			tmp[ix] = templates.get(ix);
		}
		return tmp;
	}
	
	String validateTemplateFileName(String fileName)
	{
		if(!use_internal)
		{
			try {
				String[] files = new File(templatePath(null)).list();
				for(String f:files)
				{
					String t = templatePath(f);
					if(t.equals(fileName))
					{
						return fileName;
					}
				}

				ArrayList<TemplateFile> templates = readTemplateList();
				return templates.get(0).filename;
			}
			catch(NullPointerException ne)
			{
				use_internal = true;
			}
		}
		
		if(use_internal)
		{
			String[] files = getAssetFiles();
			for(String f:files)
			{
				String t = "contact_template/" + f;
				if(t.equals(fileName))
				{
					return fileName;
				}
			}
			
			return "contact_template/" + files[0];
		}
		
		return null; //error
	}
}
