package ch.brx.ldifviewer;

import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.Menu;
import android.view.MenuItem;
import android.view.WindowManager;

public class MainActivity extends FragmentActivity {
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		boolean tabletMode = false;
		
		if ((getResources().getConfiguration().screenLayout & 
			    Configuration.SCREENLAYOUT_SIZE_MASK) == 
			        Configuration.SCREENLAYOUT_SIZE_LARGE) {
			    // on a large screen device ...
			tabletMode = true;

	    }
		
		//tabletMode = false;
		
		if(tabletMode)
		{
			setContentView(R.layout.activity_main);
		}
		else
		{
			setContentView(R.layout.activity_main_small);
		}
		
		setKeyboardMode();
		
		//TemplateManager.initManager(getWindow().getContext());
		
	}

	private void setKeyboardMode()
	{
		FragmentShowContact fragment = (FragmentShowContact) getSupportFragmentManager()
				.findFragmentById(R.id.fragmentSC);
		if (fragment != null && fragment.isInLayout())
		{
			//in portrait mode: keyboard should overlaps contact details
			//in landscape mode: resize layout to see all list till bottom
			if(getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT)
			{
				System.out.println("Large Screen Portrait");
				getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN |
						WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN);
			}
			else
			{
				System.out.println("Large Screen Landscape");
				getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);
			}
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}	
	
	@Override 
	public boolean onOptionsItemSelected(MenuItem item) 
	{ 
		switch (item.getItemId()) 
		{ 
		case R.id.menu_about: 
			FragmentAboutDialog newFragment = FragmentAboutDialog.newInstance();
			//newFragment.setTargetFragment(this, 0);
			newFragment.show(getSupportFragmentManager().beginTransaction(), "dialog");
			return(true); 
		}
		
		return(super.onOptionsItemSelected(item)); 
	}
	
}
