package ch.brx.ldifviewer;


import ch.brx.ldifviewer.TemplateManager.TemplateFile;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.AdapterView.OnItemClickListener;

public class FragmentTemplateManager extends DialogFragment {

	public static FragmentTemplateManager newInstance(){

		FragmentTemplateManager dialogFragment = new FragmentTemplateManager();
		return dialogFragment;

	}
	
	private View rootView;
	private TemplateManager tplManager;
	private ListView lvDetails;
	private Button btnEdit;
	private Button btnReset;

	private void handleItem(int position)
	{
		Button btnReset = (Button)rootView.findViewById(R.id.resetBtn);
		TemplateFile tpl = (TemplateFile)lvDetails.getItemAtPosition(position);
		if(tpl.internal)
		{
			//btnReset.setVisibility(View.VISIBLE);

			btnReset.setEnabled(true);
		}
		else
		{
			//btnReset.setVisibility(View.INVISIBLE);

			btnReset.setEnabled(false);
		}
		
		lvDetails.setTag(tpl);
		//btnEdit.setVisibility(View.VISIBLE);
		btnEdit.setEnabled(true);
	}
	
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {

		rootView = inflater.inflate(R.layout.fragment_templatemanager,
				container, false);
		getDialog().setTitle(getString(R.string.templatemanager));
		
		tplManager = TemplateManager.getManager(getActivity());
		
		TextView tvPath = (TextView)rootView.findViewById(R.id.folderpath);
		String folder = tplManager.templatePath(null);
		tvPath.setText(getString(R.string.templatefolder).concat("\n").concat(folder));
		
		TemplateFile[] tmpl = tplManager.getTemplates();
		ArrayAdapter<TemplateFile> aAdpt = new ArrayAdapter<TemplateFile>(
				getActivity(),
				R.layout.row_templateslist, 
				tmpl);
		
		
		
		
		lvDetails = (ListView)rootView.findViewById(R.id.templates);
		lvDetails.setAdapter(aAdpt);
		lvDetails.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		lvDetails.setOnItemClickListener(new OnItemClickListener() {

			@Override
			public void onItemClick(AdapterView<?> parent, View view, int position, long id) {

				handleItem(position);
			}
		});
		
		btnEdit = (Button)rootView.findViewById(R.id.editTemplate);
		btnEdit.setEnabled(false);
		//btnEdit.setVisibility(View.INVISIBLE);
		btnEdit.setOnClickListener( new View.OnClickListener() {
            public void onClick(View v) {
            	TemplateFile tpl = (TemplateFile)lvDetails.getTag();
            	if(tpl != null) 
            	{
            		Intent intent = new Intent(Intent.ACTION_EDIT);
            		Uri uri = Uri.parse("file://" + tpl.filename ); 
            		intent.setDataAndType(uri, "application/xml"); 
            		startActivity(Intent.createChooser(intent, "Edit Template..."));
            	}
            }
        });
		
		Button btnOK = (Button)rootView.findViewById(R.id.ok);
		btnOK.setOnClickListener( new View.OnClickListener() {
            public void onClick(View v) {
            	dismiss();
            }
        });
		
		btnReset = (Button)rootView.findViewById(R.id.resetBtn);
		//btnReset.setVisibility(View.INVISIBLE);
		btnReset.setEnabled(false);
		btnReset.setOnClickListener( new View.OnClickListener() {
            public void onClick(View v) {
            	TemplateFile tpl = (TemplateFile)lvDetails.getTag();
            	if(tpl != null) 
            	{
            		new AlertDialog.Builder(getActivity())
            	    .setTitle("Revert Template")
            	    .setMessage("Are you sure you want to revert template? All changes will be lost!")
            	    .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
            	        public void onClick(DialogInterface dialog, int which) { 
            	            // continue with delete
            	        	TemplateFile tpl = (TemplateFile)lvDetails.getTag();
            	        	tplManager.resetTemplate(tpl.filename);
            	        }
            	     })
            	    .setNegativeButton("No", new DialogInterface.OnClickListener() {
            	        public void onClick(DialogInterface dialog, int which) { 
            	            // do nothing
            	        }
            	     })
            	     .show();
            	}
            }
        });
		
		return rootView;
	}
	
	@Override
	public void onResume() {
		TemplateFile[] tmpl = tplManager.getTemplates();
		ArrayAdapter<TemplateFile> aAdpt = new ArrayAdapter<TemplateFile>(
				getActivity(),
				R.layout.row_templateslist, 
				tmpl);
		lvDetails.setAdapter(aAdpt);
		super.onResume();
	}
}
