package ch.brx.ldifviewer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;


public class FragmentShowContactDetail extends DialogFragment {

	public FragmentShowContactDetail() {
	}
	
	public static FragmentShowContactDetail newInstance(Map<String, List<String>> addressEntry){

		FragmentShowContactDetail dialogFragment = new FragmentShowContactDetail();
		
		ArrayList<String> values = new ArrayList<String>();
		
		Iterator<Entry<String, List<String>>> it = addressEntry.entrySet().iterator();
	    while (it.hasNext()) {
	    	Entry<String, List<String>> pairs = (Entry<String, List<String>>)it.next();
	    	for(String s: pairs.getValue())
	    	{
	    		values.add(pairs.getKey().concat(": ").concat(s));
	    	}
	    }
		
	    Bundle bundle = new Bundle();
	    bundle.putStringArrayList("value", values);
	    dialogFragment.setArguments(bundle);
	    return dialogFragment;

	}
	
	
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {

		View rootView = inflater.inflate(R.layout.fragment_showcontactdetail,
				container, false);
		Bundle arguments = getArguments();
		
		getDialog().setTitle(getString(R.string.details));
		
		ArrayAdapter<String> aAdpt = new ArrayAdapter<String>(getActivity(),
				R.layout.row_contactlistdetail, 
				arguments.getStringArrayList("value"));
		
		ListView lvDetails = (ListView)rootView.findViewById(R.id.details);
		lvDetails.setAdapter(aAdpt);
		
		Button btnDismiss = (Button)rootView.findViewById(R.id.dismiss);
		btnDismiss.setOnClickListener( new View.OnClickListener() {
            public void onClick(View v) {
            	dismiss();
            }
        });

		return rootView;
	}
	
}

