package ch.brx.ldifviewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import android.os.Bundle;
import android.app.Activity;
import android.support.v4.app.DialogFragment;
import android.content.Context;
import android.content.Intent;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ListView;
import android.widget.TextView;

/**
 * A dummy fragment representing a section of the app, but that simply
 * displays dummy text.
 */
public class FragmentMailSelectorDialog extends DialogFragment {

	public FragmentMailSelectorDialog() {
	}
	
	public static FragmentMailSelectorDialog newInstance(String [] mailDisplayList, String [] mailValue){

		FragmentMailSelectorDialog dialogFragment = new FragmentMailSelectorDialog();
	    Bundle bundle = new Bundle();
	    bundle.putStringArray("display", mailDisplayList);
	    bundle.putStringArray("value", mailValue);
	    dialogFragment.setArguments(bundle);
	    return dialogFragment;

	}

	//statics
	static private String storedRecipientList = new String();

	//object handles
	private View rootView;
	private TextView tvRecipientList = null;
	private Button btnSendall;
	
	//values
	private String[] mailValuesList = null;
	
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {

		rootView = inflater.inflate(R.layout.fragment_mailselectordialog,
				container, false);
		Bundle arguments = getArguments();
		
		getDialog().setTitle(getString(R.string.selectmails));
		
		ArrayAdapter<String> aAdpt = new AddressArrayAdapter(getActivity(),
				R.layout.row_mailselectordialog, R.id.mailaddress, 
				new ArrayList<String>( Arrays.asList(arguments.getStringArray("display")) )
	   );
		
		mailValuesList = arguments.getStringArray("value");
		
		ListView lvAddresses = (ListView)rootView.findViewById(R.id.addresses);
		lvAddresses.setAdapter(aAdpt);
		lvAddresses.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		tvRecipientList = (TextView)rootView.findViewById(R.id.recipientlist);
		tvRecipientList.setText(storedRecipientList);
		tvRecipientList.addTextChangedListener(new TextWatcher() {

			@Override
			public void onTextChanged(CharSequence s, int start, int before, int count) {
				updateRecipientList();
			}

			@Override
			public void beforeTextChanged(CharSequence s, int start, int count,
					int after) {

			}

			@Override
			public void afterTextChanged(Editable s) {
			}

		});
		
		btnSendall = (Button)rootView.findViewById(R.id.sendtorecipients);
		btnSendall.setOnClickListener( new View.OnClickListener() {
            public void onClick(View v) {
            	
            	String mails = tvRecipientList.getText().toString();
            	tvRecipientList.setText("");
            	
            	updateRecipientList();
            	
            	Intent intent = new Intent();
            	intent.putExtra("addresses", mails);
            	
            	getTargetFragment().onActivityResult(
            			getTargetRequestCode(), 
            			Activity.RESULT_OK, 
            			intent);
            	dismiss();
            }
        });
		
		if(tvRecipientList.getText().toString().length() > 0)
		{
			btnSendall.setEnabled(true);
		}
		else
		{
			btnSendall.setEnabled(false);
		}
		
		Button btnDismiss = (Button)rootView.findViewById(R.id.dismiss);
		btnDismiss.setOnClickListener( new View.OnClickListener() {
            public void onClick(View v) {
           	
            	Intent intent = new Intent();
            	intent.putExtra("addresses", "");
            	
            	if(tvRecipientList.getText().length() > 0)
            	{
            		getTargetFragment().onActivityResult(
                			getTargetRequestCode(), 
                			Activity.RESULT_OK, 
                			intent);
            	}
            	else
            	{
            		getTargetFragment().onActivityResult(
                			getTargetRequestCode(), 
                			Activity.RESULT_CANCELED, 
                			intent);
            	}
            	dismiss();
            }
        });

		return rootView;
	}
	
	private void updateRecipientList()
	{
		storedRecipientList = tvRecipientList.getText().toString();
		if(tvRecipientList.getText().toString().length() > 0)
		{
			btnSendall.setEnabled(true);
		}
		else
		{
			btnSendall.setEnabled(false);
		}
	}
	
	private class AddressArrayAdapter extends ArrayAdapter<String>
	{

		private List<String> mailDisplayList;
		private final LayoutInflater mInflater;

		public AddressArrayAdapter(Context ctx, int resource,
				List<String> objects) {
			super(ctx, resource, objects);
			mInflater = LayoutInflater.from(ctx);
			mailDisplayList = objects;
		}
		
		public AddressArrayAdapter(Context ctx, int resource, 
				int textViewResourceId, List<String> objects){
			super(ctx, resource, textViewResourceId, objects);
			mInflater = LayoutInflater.from(ctx);
			mailDisplayList = objects;
		}

		public View getView(int position, View convertView, ViewGroup parent) 
		{ 
			View row=convertView; 

			if (row==null) {                          
				row=mInflater.inflate(R.layout.row_mailselectordialog, parent, false); 
			} 

			TextView label=(TextView)row.findViewById(R.id.mailaddress); 
			label.setText(mailDisplayList.get(position)); 
			
			ImageButton plus = (ImageButton)row.findViewById(R.id.add);
			plus.setTag(mailValuesList[position]);
			plus.setOnClickListener( new View.OnClickListener() {
                public void onClick(View v) {
                	String r = (String)v.getTag();
                	if(tvRecipientList.getText().toString().length() > 0)
                	{
                		tvRecipientList.setText(tvRecipientList.getText().toString() + ";" + r);
                	}
                	else
                	{
                		tvRecipientList.setText(r);
                	}
                	updateRecipientList();
                	
                }
            });
			
			ImageButton send = (ImageButton)row.findViewById(R.id.send);
			send.setTag(label);
			send.setOnClickListener( new View.OnClickListener() {
                public void onClick(View v) {
                	TextView tv = (TextView)v.getTag();
                	
                	Intent intent = new Intent();
                	intent.putExtra("addresses", tv.getText());
                	
                	getTargetFragment().onActivityResult(
                			getTargetRequestCode(), 
                			Activity.RESULT_OK, 
                			intent);
                	dismiss();
                }
            });


			return(row); 
		} 
	}
	
}

