package ch.brx.ldifviewer;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import ch.brx.ldifviewer.ContactsReader.NameSchema;

import android.os.Bundle;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.support.v4.app.Fragment;
import android.support.v4.content.Loader;
import android.support.v4.app.LoaderManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageButton;
import android.widget.ListView;

/**
 * A dummy fragment representing a section of the app, but that simply
 * displays dummy text.
 */
public class FragmentContactList extends Fragment 
implements OnClickListener, LoaderManager.LoaderCallbacks<List<ContactsReader.ContactListEntry>> 
{

	public FragmentContactList() {
	}

	private ListView lvContacts = null;
	private EditText etSearch = null;
	private ContactArrayAdapter lvContactsAdpt = null;
	private View azView;
	
	private ScrollViewInfo scrollView = null;
	private ImageButton btnUp = null;
	private ImageButton btnDown = null;

	private String fileName = null;
	private String tplFileName = null;

	private final String prefFileName = "ch.brx.ldifviewer.filename";
	private final String prefTmplFileName = "ch.brx.ldifviewer.tmplfilename";
	private final String prefNameSchema = "ch.brx.ldifviewer.nameschema";

	ContactLoader myLoader = null;

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) 
	{
		setHasOptionsMenu(true);

		View rootView = inflater.inflate(R.layout.fragment_contactlist,
				container, false);

		setupScroll(rootView);
		setupList(rootView);
		setupAZ(rootView);
		setupSearchField(rootView);

		LoaderManager lm = getLoaderManager();
		final int LOADER_ID = 1;
		myLoader = (ContactLoader)lm.initLoader(LOADER_ID, null, this);

		SharedPreferences prefs = getActivity().getSharedPreferences(
				"ch.brx.ldifvier", Context.MODE_PRIVATE);

		fileName = prefs.getString(prefFileName, null);
		tplFileName = prefs.getString(prefTmplFileName, "");
		tplFileName = TemplateManager.getManager(getActivity()).
				validateTemplateFileName(tplFileName);
		prefs.edit().putString(prefTmplFileName, tplFileName).commit();

		if(fileName != null)
		{
			loadFile();
		}
		else
		{
			showOpenFileDialog();
		}

		return rootView;
	}
	
	private void setupScroll(View rootView)
	{
		btnUp = (ImageButton)rootView.findViewById(R.id.upBtn);
		btnDown = (ImageButton)rootView.findViewById(R.id.downBtn);
		btnUp.setVisibility(View.INVISIBLE);
		btnDown.setOnClickListener(this);
		btnUp.setOnClickListener(this);

		scrollView = (ScrollViewInfo) rootView.findViewById(R.id.scrollViewABC);
		scrollView.setScrollViewListener(new ScrollViewListener() {
			public void onScrollChanged(ScrollViewInfo scrollView, int x, int y, int oldx, int oldy)
			{
				updateArrows();
			}
		});
	}

	private void updateArrows()
	{
		if(scrollView.getScrollY() < 10)
		{
			btnUp.setVisibility(View.INVISIBLE);
		}
		else 
		{
			btnUp.setVisibility(View.VISIBLE);
			
			View view = (View) scrollView.getChildAt(scrollView.getChildCount() - 1);
			int diff = (view.getBottom() - (scrollView.getHeight() + scrollView.getScrollY()));

			if(diff < 10)
			{
				btnDown.setVisibility(View.INVISIBLE);
			}
			else
			{
				btnDown.setVisibility(View.VISIBLE);
			}
		}
		
	}

	private void setupList(View rootView)
	{
		lvContacts = (ListView) rootView.findViewById(R.id.frgmt_addresses_listView1);

		ArrayList<ContactsReader.ContactListEntry> l = new ArrayList<ContactsReader.ContactListEntry>();

		lvContactsAdpt = new ContactArrayAdapter(getActivity(), R.layout.row_contactlist, l);
		lvContacts.setAdapter(lvContactsAdpt);
		lvContacts.setChoiceMode(ListView.CHOICE_MODE_SINGLE);

		lvContacts.setTextFilterEnabled(true);
		lvContacts.setOnItemClickListener(new OnItemClickListener() {

			@Override
			public void onItemClick(AdapterView<?> parent, View view, int position, long id) {

				InputMethodManager imm = (InputMethodManager) 
						getActivity().getSystemService(Activity.INPUT_METHOD_SERVICE);
				imm.hideSoftInputFromWindow(view.getWindowToken(), 0);

				ContactsReader.ContactListEntry le = (ContactsReader.ContactListEntry)lvContacts.getItemAtPosition(position);
				showContact(le.dn);
			}
		});
	}

	private void showContact(String dn) {
		FragmentShowContact fragment = (FragmentShowContact) getFragmentManager()
				.findFragmentById(R.id.fragmentSC);
		if (fragment != null && fragment.isInLayout()) {
			fragment.showContact(fileName, tplFileName, dn);
		} else {
			Intent intent = new Intent(getActivity(),
					ActivityShowContact.class);
			//intent.putExtra(ShowAddress.EXTRA_URL, link);

			intent.putExtra("file", fileName);
			intent.putExtra("templFileName", tplFileName);
			intent.putExtra("dn", dn);

			startActivity(intent);

		}
	}

	private void clearContact() {
		FragmentShowContact fragment = (FragmentShowContact) getFragmentManager()
				.findFragmentById(R.id.fragmentSC);
		if (fragment != null && fragment.isInLayout()) {
			fragment.clearContact();
		} 
	}



	private void setupAZ(View rootView)
	{
		((Button)rootView.findViewById(R.id.ButtonA)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonB)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonC)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonD)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonE)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonF)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonG)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonH)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonI)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonJ)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonK)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonL)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonM)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonN)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonO)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonP)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonQ)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonR)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonS)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonT)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonU)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonV)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonW)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonX)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonY)).setOnClickListener(this);
		((Button)rootView.findViewById(R.id.ButtonZ)).setOnClickListener(this);
		
		azView = rootView.findViewById(R.id.azView);
	}

	private void hideAZ()
	{
		azView.setVisibility(View.GONE);
	}

	private void showAZ()
	{
		azView.setVisibility(View.VISIBLE);
	}

	public void onClick(View v) {
		View rootView = v.getRootView();
		final ListView listview = (ListView) rootView.findViewById(R.id.frgmt_addresses_listView1);

		switch (v.getId()) 
		{
		case R.id.ButtonA:
			listview.setSelection(lvContactsAdpt.char2pos('A'));
			break;
		case R.id.ButtonB:
			listview.setSelection(lvContactsAdpt.char2pos('B'));
			break;
		case R.id.ButtonC:
			listview.setSelection(lvContactsAdpt.char2pos('C'));
			break;
		case R.id.ButtonD:
			listview.setSelection(lvContactsAdpt.char2pos('D'));
			break;
		case R.id.ButtonE:
			listview.setSelection(lvContactsAdpt.char2pos('E'));
			break;
		case R.id.ButtonF:
			listview.setSelection(lvContactsAdpt.char2pos('F'));
			break;
		case R.id.ButtonG:
			listview.setSelection(lvContactsAdpt.char2pos('G'));
			break;
		case R.id.ButtonH:
			listview.setSelection(lvContactsAdpt.char2pos('H'));
			break;
		case R.id.ButtonI:
			listview.setSelection(lvContactsAdpt.char2pos('I'));
			break;
		case R.id.ButtonJ:
			listview.setSelection(lvContactsAdpt.char2pos('J'));
			break;
		case R.id.ButtonK:
			listview.setSelection(lvContactsAdpt.char2pos('K'));
			break;
		case R.id.ButtonL:
			listview.setSelection(lvContactsAdpt.char2pos('L'));
			break;
		case R.id.ButtonM:
			listview.setSelection(lvContactsAdpt.char2pos('M'));
			break;
		case R.id.ButtonN:
			listview.setSelection(lvContactsAdpt.char2pos('N'));
			break;
		case R.id.ButtonO:
			listview.setSelection(lvContactsAdpt.char2pos('O'));
			break;
		case R.id.ButtonP:
			listview.setSelection(lvContactsAdpt.char2pos('P'));
			break;
		case R.id.ButtonQ:
			listview.setSelection(lvContactsAdpt.char2pos('Q'));
			break;
		case R.id.ButtonR:
			listview.setSelection(lvContactsAdpt.char2pos('R'));
			break;
		case R.id.ButtonS:
			listview.setSelection(lvContactsAdpt.char2pos('S'));
			break;
		case R.id.ButtonT:
			listview.setSelection(lvContactsAdpt.char2pos('T'));
			break;
		case R.id.ButtonU:
			listview.setSelection(lvContactsAdpt.char2pos('U'));
			break;
		case R.id.ButtonV:
			listview.setSelection(lvContactsAdpt.char2pos('V'));
			break;
		case R.id.ButtonW:
			listview.setSelection(lvContactsAdpt.char2pos('W'));
			break;
		case R.id.ButtonX:
			listview.setSelection(lvContactsAdpt.char2pos('X'));
			break;
		case R.id.ButtonY:
			listview.setSelection(lvContactsAdpt.char2pos('Y'));
			break;
		case R.id.ButtonZ:
			listview.setSelection(lvContactsAdpt.char2pos('Z'));
			break;
		case R.id.upBtn:
			scrollView.arrowScroll(View.FOCUS_UP);
			updateArrows();
			break;
		case R.id.downBtn:
			scrollView.arrowScroll(View.FOCUS_DOWN);
			updateArrows();
			break;
		}
	}

	private void setupSearchField(View rootView)
	{
		etSearch = (EditText)rootView.findViewById(R.id.frgmt_addresses_searchbox1);

		etSearch.addTextChangedListener(new TextWatcher() {

			@Override
			public void onTextChanged(CharSequence s, int start, int before, int count) {
				lvContactsAdpt.getFilter().filter(s.toString()); 
				lvContacts.clearChoices();
				if(s.length() > 0)
				{
					hideAZ();
				}
				else
				{
					showAZ();
				}
			}

			@Override
			public void beforeTextChanged(CharSequence s, int start, int count,
					int after) {

			}

			@Override
			public void afterTextChanged(Editable s) {
			}

		});

		if ( etSearch.getText().length() > 0 )
		{
			lvContactsAdpt.getFilter().filter(etSearch.getText());
		}
	}


	final int REQUEST_OPEN = 5;

	private void showOpenFileDialog()
	{
		FragmentOpenFileDialog newFragment = FragmentOpenFileDialog.newInstance(fileName, 
				new String[] { "ldif", "ldf", "csv" },
				tplFileName);
		newFragment.setTargetFragment(this, REQUEST_OPEN);
		newFragment.show(getFragmentManager().beginTransaction(), "dialog");
	}
	
	private void showTemplateManagerDialog()
	{
		FragmentTemplateManager newFragment = FragmentTemplateManager.newInstance();
		newFragment.setTargetFragment(this, REQUEST_OPEN);
		newFragment.show(getFragmentManager().beginTransaction(), "dialog");
	}



	@Override 
	public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) 
	{ 
		getActivity().getMenuInflater().inflate(R.menu.contactlist, menu);
		
		if(!TemplateManager.getManager(getActivity()).externalTemplates())
		{
			menu.findItem(R.id.menu_templatemanager).setEnabled(false);
		}
		
		super.onCreateOptionsMenu(menu, inflater);
	} 

	@Override 
	public boolean onOptionsItemSelected(MenuItem item) { 

		SharedPreferences prefs = getActivity().getSharedPreferences(
				"ch.brx.ldifvier", Context.MODE_PRIVATE);

		switch (item.getItemId()) 
		{ 
		case R.id.menu_usecallname: 
			prefs.edit().putInt(prefNameSchema, NameSchema.USE_NAME_CALL.ordinal()).commit();
			loadFile();
			return(true); 

		case R.id.menu_usefirstlast: 
			prefs.edit().putInt(prefNameSchema, NameSchema.USE_NAME_FIRST_LAST.ordinal()).commit();
			loadFile();
			return(true); 

		case R.id.menu_uselastfirst: 
			prefs.edit().putInt(prefNameSchema, NameSchema.USE_NAME_LAST_FIRST.ordinal()).commit();
			loadFile();
			return(true); 

		case R.id.menu_openfile:
			showOpenFileDialog();
			return(true);
			
		case R.id.menu_templatemanager:
			showTemplateManagerDialog();
			return(true);
		}

		return(super.onOptionsItemSelected(item)); 
	}

	@Override
	public synchronized void onActivityResult(final int requestCode,
			int resultCode, final Intent data) {

		if (resultCode == Activity.RESULT_OK) 
		{
			if (requestCode == REQUEST_OPEN) {
				String fileName = data.getStringExtra(FragmentOpenFileDialog.RESULT_PATH);
				String tplFileName = data.getStringExtra(FragmentOpenFileDialog.TEMPLATE_FILE);

				SharedPreferences prefs = getActivity().getSharedPreferences(
						"ch.brx.ldifvier", Context.MODE_PRIVATE);
				prefs.edit().putString(prefFileName, fileName).commit();
				prefs.edit().putString(prefTmplFileName, tplFileName).commit();

				clearContact();

				loadFile();
			} 
		} 

	}

	ProgressDialog pd = null;

	private void loadFile()
	{
		if(myLoader != null)
		{
			SharedPreferences prefs = getActivity().getSharedPreferences(
					"ch.brx.ldifvier", Context.MODE_PRIVATE);

			fileName = prefs.getString(prefFileName, null);
			tplFileName = prefs.getString(prefTmplFileName, null);
			NameSchema nameSchema = NameSchema.values()[prefs.getInt(prefNameSchema, 0)];

			myLoader.setFile(fileName, nameSchema, tplFileName);

			pd = new ProgressDialog(getActivity());
			pd.setTitle("Load File...");
			pd.setCancelable(false);
			pd.setMessage(fileName);
			pd.setProgressStyle(ProgressDialog.STYLE_SPINNER);
			pd.show();
		}
		else
		{
			System.err.println("Async Task Loader not available...");
		}
	}

	public Loader<List<ContactsReader.ContactListEntry>> onCreateLoader(int id, Bundle args)
	{ 
		return new ContactLoader(getActivity());
		//return myLoader;
	}

	public void onLoadFinished(Loader<List<ContactsReader.ContactListEntry>> loader, List<ContactsReader.ContactListEntry> data) 
	{  
		if(pd != null)
		{
			pd.dismiss();
		}

		lvContactsAdpt.swapData(data);
		if ( etSearch != null && etSearch.getText().length() > 0 )
		{
			lvContactsAdpt.getFilter().filter(etSearch.getText());
		}
	}

	public void onLoaderReset(Loader<List<ContactsReader.ContactListEntry>> loader) 
	{ 
		lvContactsAdpt.swapData(new ArrayList<ContactsReader.ContactListEntry>());
	}


	private class ContactArrayAdapter extends ArrayAdapter<ContactsReader.ContactListEntry> implements Filterable
	{

		private List<ContactsReader.ContactListEntry> contactList;
		private List<ContactsReader.ContactListEntry> origContactList;
		private Filter contactFilter;
		public final Object mLock = new Object();

		public ContactArrayAdapter(Context ctx, int textViewResourceId,
				List<ContactsReader.ContactListEntry> objects) {
			super(ctx, textViewResourceId, objects);
			contactList = objects;
			origContactList = objects;
		}

		public int getCount() {
			return contactList.size();
		}

		public ContactsReader.ContactListEntry getItem(int position) {
			return contactList.get(position);
		}

		public long getItemId(int position) {
			return contactList.get(position).hashCode();
		}

		public void swapData(List<ContactsReader.ContactListEntry> objects)
		{
			synchronized (mLock) {
				contactList = objects;
				origContactList = objects;
			}

			notifyDataSetChanged();
		}

		public int char2pos(char c)
		{
			if(contactList != null)
			{
				for (int i = 0; i < contactList.size(); i++) {
					if(contactList.get(i).name.toUpperCase(Locale.US).charAt(0) >= c) return i;
				}

				return contactList.size();
			}

			return 0;
		}

		//public void resetData() {
		//	contactList = origContactList;
		//}


		@Override
		public Filter getFilter() {
			if (contactFilter == null)
				contactFilter = new ContactFilter();

			return contactFilter;
		}

		private class ContactFilter extends Filter {



			@Override
			protected FilterResults performFiltering(CharSequence constraint) {
				FilterResults results = new FilterResults();
				// We implement here the filter logic
				if (constraint == null || constraint.length() == 0) {
					// No filter implemented we return all the list
					synchronized (mLock) {
						results.values = origContactList;
						results.count = origContactList.size();
					}
				}
				else {
					// We perform filtering operation
					synchronized (mLock) {
						List<ContactsReader.ContactListEntry> nContactList = new ArrayList<ContactsReader.ContactListEntry>();

						for (ContactsReader.ContactListEntry p : origContactList) {

							if (p.name.toUpperCase(Locale.US).contains(
									constraint.toString().toUpperCase(Locale.US) ) ||
									p.info.toUpperCase(Locale.US).contains(
											constraint.toString().toUpperCase(Locale.US) )	
									)
							{
								nContactList.add(p);
							}
						}

						results.values = nContactList;
						results.count = nContactList.size();
					}

				}
				return results;
			}

			@SuppressWarnings("unchecked")
			@Override
			protected void publishResults(CharSequence constraint,
					FilterResults results) {

				synchronized (mLock) {
					// Now we have to inform the adapter about the new list filtered
					contactList = (List<ContactsReader.ContactListEntry>) results.values;
					notifyDataSetChanged();
				}

			}

		}
	}
}

