/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLMessages;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ValidityDateTrustManager
implements X509TrustManager {
    private static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        ValidityDateTrustManager.checkCertificateValidity(chain[0]);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        ValidityDateTrustManager.checkCertificateValidity(chain[0]);
    }

    private static void checkCertificateValidity(X509Certificate c) throws CertificateException {
        Date currentTime = new Date();
        Date notBefore = c.getNotBefore();
        Date notAfter = c.getNotAfter();
        if (currentTime.before(notBefore)) {
            throw new CertificateException(SSLMessages.ERR_VALIDITY_TOO_EARLY.get(c.getSubjectX500Principal().getName("RFC2253"), String.valueOf(notBefore)));
        }
        if (currentTime.after(c.getNotAfter())) {
            throw new CertificateException(SSLMessages.ERR_VALIDITY_TOO_LATE.get(c.getSubjectX500Principal().getName("RFC2253"), String.valueOf(notAfter)));
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return NO_CERTIFICATES;
    }
}

